% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Constant.GT.R
\name{TwoSample.Constant.GT}
\alias{TwoSample.Constant.GT}
\title{Function to compute calibration constants for the two-sample generalized-t statistics.}
\usage{
TwoSample.Constant.GT(data)
}
\arguments{
\item{data}{A data frame generated by \code{TwoSamaple.generate.sequential()}.}
}
\value{
\itemize{
\item The calibration constant \code{power.const}. Defined as the integral of the generalized-t's weight
function times the control group's mean frequency increment over \code{[0,3]}.
\item The estimated asymptotic variance of the integrated two-sample generalized-t statistics over \code{[0,3]}.
}
}
\description{
Computes two quantities used for power/effect-size calibration of the two-sample generalized-t statistics.
The function evaluates the generalized-t statistics up to a
fixed event-time horizon \code{tau = 3}, then returns (i) an integral
\eqn{\int_0^{\tau} K_{LR}(t)\, d\mu_1(t)} based on the control group mean-frequency
increment and (ii) the asymptotic variance of the integrated statistic.
}
