% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsNBCalendar.R
\name{toInteger}
\alias{toInteger}
\alias{toInteger.gsDesign}
\alias{toInteger.gsNB}
\title{Convert group sequential design to integer sample sizes}
\usage{
toInteger(x, ...)

\method{toInteger}{gsDesign}(x, ratio = x$ratio, roundUpFinal = TRUE, ...)

\method{toInteger}{gsNB}(x, ratio = x$nb_design$inputs$ratio, roundUpFinal = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{gsNB} or \code{gsDesign}.}

\item{...}{Additional arguments passed to methods.}

\item{ratio}{Randomization ratio (n2/n1). If an integer is provided, rounding
is done to a multiple of \code{ratio + 1}. If \code{ratio < 1} and \code{1/ratio} is an
integer (e.g., 1:2 allocation, ratio = 0.5), rounding is done to a multiple
of \code{1/ratio + 1}. Default uses the ratio from the original design.}

\item{roundUpFinal}{If \code{TRUE} (default), the final sample size is rounded
up to ensure the target is met. If \code{FALSE}, rounding is to the nearest
integer.}
}
\value{
An object of the same class as input with integer sample sizes.
}
\description{
Generic function to round sample sizes in a group sequential design to integers.
This extends the \code{\link[gsDesign:toInteger]{gsDesign::toInteger()}} function from the gsDesign
package to work with \code{gsNB} objects.
}
\details{
This function rounds sample sizes at each analysis to integers while maintaining
the randomization ratio and ensuring monotonically increasing sample sizes across
analyses. Only the final analysis sample size is rounded to an integer;
interim sample sizes remain as expected (non-integer) values based on
the information fraction.

When \code{analysis_times} were provided to \code{\link[=gsNBCalendar]{gsNBCalendar()}},
the statistical information (\code{n.I}) is recomputed at each analysis
time based on the new sample size and expected exposures.
}
\section{Methods (by class)}{
\itemize{
\item \code{toInteger(gsDesign)}: Method for \code{gsDesign} objects (calls \code{\link[gsDesign:toInteger]{gsDesign::toInteger()}}).

\item \code{toInteger(gsNB)}: Method for \code{gsNB} objects.

Rounds sample sizes in a group sequential negative binomial design to integers,
respecting the randomization ratio.

}}
\examples{
nb_ss <- sample_size_nbinom(
  lambda1 = 0.5, lambda2 = 0.3, dispersion = 0.1, power = 0.9,
  accrual_rate = 10, accrual_duration = 20, trial_duration = 24
)
gs_design <- gsNBCalendar(nb_ss, k = 3, analysis_times = c(12, 18, 24))
gs_integer <- toInteger(gs_design)
}
