% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsNBCalendar.R
\name{summary.gsNB}
\alias{summary.gsNB}
\title{Summary for gsNB objects}
\usage{
\method{summary}{gsNB}(object, ...)
}
\arguments{
\item{object}{An object of class \code{gsNB}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A character string summarizing the design (invisibly). The summary
is also printed to the console.
}
\description{
Provides a textual summary of a group sequential design for negative binomial
outcomes, similar to the summary provided by \code{\link[gsDesign:gsDesign]{gsDesign::gsDesign()}}.
For tabular output, use \code{\link[gsDesign:gsBoundSummary]{gsDesign::gsBoundSummary()}} directly on
the gsNB object.
}
\examples{
nb_ss <- sample_size_nbinom(
  lambda1 = 0.5, lambda2 = 0.3, dispersion = 0.1, power = 0.9,
  accrual_rate = 10, accrual_duration = 20, trial_duration = 24
)
gs_design <- gsNBCalendar(nb_ss, k = 3, analysis_times = c(12, 18, 24))
summary(gs_design)

# For tabular bounds summary, use gsBoundSummary() directly:
gsBoundSummary(gs_design)
}
