% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_gs_sim.R
\name{summarize_gs_sim}
\alias{summarize_gs_sim}
\title{Summarize group sequential simulation results}
\usage{
summarize_gs_sim(x)
}
\arguments{
\item{x}{A data frame returned by \code{\link[=check_gs_bound]{check_gs_bound()}} (or \code{\link[=sim_gs_nbinom]{sim_gs_nbinom()}} if
bounds are manually checked). Must contain columns \code{cross_upper}, \code{cross_lower}.}
}
\value{
A list containing:
\describe{
\item{n_sim}{Number of simulations}
\item{power}{Overall power (probability of crossing upper bound)}
\item{futility}{Overall futility rate (probability of crossing lower bound and not upper)}
\item{analysis_summary}{Data frame with per-analysis statistics (events, crossings)}
}
}
\description{
Provides a summary of the operating characteristics of the group sequential design
based on simulation results.
}
\examples{
design <- gsDesign::gsDesign(k = 2, n.fix = 80, test.type = 2, timing = c(0.5, 1))
sim_df <- data.frame(
  sim = c(1, 1, 2, 2),
  analysis = c(1, 2, 1, 2),
  z_stat = c(2.4, NA, -0.5, 1.9),
  blinded_info = c(40, 80, 40, 80),
  unblinded_info = c(40, 80, 40, 80),
  n_enrolled = c(30, 60, 30, 60),
  events_total = c(12, 25, 10, 22)
)
bounds_checked <- check_gs_bound(sim_df, design)
summarize_gs_sim(bounds_checked)
}
