% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmodel.preset.R
\name{gmodel.preset}
\alias{gmodel.preset}
\title{Generate one of pre-specified graphons.}
\usage{
gmodel.preset(n, id = 1, sort = TRUE)
}
\arguments{
\item{n}{the number of nodes for a graphon to be generated.}

\item{id}{an integer from 1 to 10, each corresponding to a specific graphon model.}

\item{sort}{a logical value; TRUE to sort in an decreasing order of degree, FALSE otherwise.}
}
\value{
an \eqn{(n\times n)} graphon matrix.
}
\description{
\code{gmodel.preset} generates one of pre-specified graphons
of size \eqn{(n \times n)}. Users can select one of 10 different graphons by
their \code{id}, an integer from 1 to 10. The table of available graphons
follows that of the reference article given below.
}
\examples{
\dontrun{
## Generate 3 random graphons of nodal size 100.
n  = 100
r3 = (sample(1:10,3))
W1 = gmodel.preset(n,id=r3[1])
W2 = gmodel.preset(n,id=r3[2])
W3 = gmodel.preset(n,id=r3[3])

## Generate corresponding observations and plot them
A1 = gmodel.P(W1)
A2 = gmodel.P(W2)
A3 = gmodel.P(W3)

\dontshow{
 for (i in 1:10){
   W = gmodel.preset(100,id=i)
 }
}
}

}
\references{
\insertRef{chan2014}{graphon}
}
