% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{goose_async}
\alias{goose_async}
\title{Async and Parallel Execution Module for GooseR}
\usage{
goose_async(query, session_id = NULL)
}
\arguments{
\item{query}{The query to execute}

\item{session_id}{Optional session ID}
}
\value{
A promise that resolves to the response
}
\description{
Provides asynchronous and parallel query execution

Run a query in the background and return a promise
}
\examples{
\dontrun{
library(promises)

# Single async query
goose_async("Explain async programming") \%...>\%
  { cat("Response:", .) }

# Chain multiple async operations
goose_async("Write a function") \%...>\%
  { goose_async(paste("Optimize this:", .)) } \%...>\%
  { cat("Optimized:", .) }
}
}
