% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_glmstarma.R
\name{summary.glmstarma}
\alias{summary.glmstarma}
\title{Summarize the results of a glmstarma model}
\usage{
\method{summary}{glmstarma}(object, ...)
}
\arguments{
\item{object}{An object of class \code{glmstarma}}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
An object of class \code{summary.glmstarma} which contains the following elements
\itemize{
\item call: The function call to fit the model
\item coefficients: The estimated coefficients of the model with approximate standard errors, z- and p-values. See details.
\item distribution: The marginal distribution of the conditional observations.
\item link: The link-function used to connect the conditional mean with the linear process.
\item dispersion: The dispersion parameter of the conditional distribution
\item estimate_dispersion: logical value indicating whether \code{dispersion} was estimated (\code{TRUE}) or fixed by the distribution or user (\code{FALSE})
\item df: Number of estimated coefficients in the model
\item log_likelihood: The quasi-log-likelihood of the estimated model. See details.
\item aic: Akaike Information Criterion of the estimated model, see \link{information_criteria} with \code{adjust = TRUE}.
\item bic: Bayesian Information Criterion of the estimated model, see \link{information_criteria} with \code{adjust = TRUE}.
\item qic: Quasi Information Criterion of the estimated model, see \link{QIC} with \code{adjust = TRUE}.
}
}
\description{
This functions summarizes the model fit of a glmstarma model
}
\details{
Standard errors, z-values and p-values are computed assuming asymptotic normality of the parameter estimation. The variance estimation is based on the sandwich estimator to adjust for quasi-maximum-likelihood estimation.

If the model requires non-negative parameters, the p-values are adjusted accordingly. Note that this adjustment is only valid for testing single parameters against the null hypothesis of being zero.
If multiple parameters are tested simultaneously, or a linear combination of them, a different adjustment is necessary.
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary

model_autoregressive <- list(past_obs = rep(1, 7))
fit <- glmstarma(chickenpox, model_autoregressive, W_hungary, family = vpoisson("log"),
                 covariates = list(population = population_hungary))
summary(fit)
}
}
\seealso{
\link{glmstarma}, \link{logLik}, \link{AIC}, \link{BIC}, \link{QIC}, \link{logLik.glmstarma}, \link{AIC.glmstarma}, \link{BIC.glmstarma}
}
