% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-ports.R
\encoding{UTF-8}
\name{gisco_get_ports}
\alias{gisco_get_ports}
\title{Ports dataset}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/transport-networks}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata}.
}
\usage{
gisco_get_ports(
  year = c(2013, 2009),
  country = NULL,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\code{2013}, \code{2009}.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset includes the location of over 2,440 Pan European ports. The
ports are identified following the UN LOCODE list.
}
\details{
Dataset includes objects in \href{https://epsg.io/4326}{EPSG:4326}.

\code{\link[=gisco_get_ports]{gisco_get_ports()}} adds a new field CNTR_ISO2 to the original data
identifying the country of the port.
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
library(sf)

ports <- gisco_get_ports(2013)
coast <- giscoR::gisco_coastal_lines

if (!is.null(ports)) {
  library(ggplot2)

  ggplot(coast) +
    geom_sf(fill = "grey10", color = "grey20") +
    geom_sf(
      data = ports, color = "#6bb857",
      size = 0.2, alpha = 0.25
    ) +
    theme_void() +
    theme(
      plot.background = element_rect(fill = "black"),
      text = element_text(color = "white"),
      panel.grid = element_blank(),
      plot.title = element_text(face = "bold", hjust = 0.5),
      plot.subtitle = element_text(face = "italic", hjust = 0.5)
    ) +
    labs(
      title = "Ports Worldwide", subtitle = "Year 2013",
      caption = "Source: Eurostat, Ports 2013 dataset."
    ) +
    coord_sf(crs = "ESRI:54030")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other transport networks datasets:
\code{\link{gisco_get_airports}()}
}
\concept{transport}
