% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.vegan_pco.R
\name{fortify.vegan_pco}
\alias{fortify.vegan_pco}
\alias{tidy.vegan_pco}
\title{Fortify a \code{"vegan_pco"} object.}
\usage{
\method{fortify}{vegan_pco}(model, data = NULL, axes = 1:6, ...)

\method{tidy}{vegan_pco}(x, data = NULL, axes = 1:6, const = NULL, ...)
}
\arguments{
\item{model, x}{an object of class \code{"vegan_pco"}, the result of a call to
\code{\link[vegan:dbrda]{vegan::pco()}}.}

\item{data}{currently ignored.}

\item{axes}{numeric; which axes to extract scores for.}

\item{...}{additional arguments passed to \code{\link[vegan:plot.cca]{vegan::scores.rda()}}.}

\item{const}{NULL; General scaling constant to RDA scores. See
\code{\link[vegan:plot.cca]{vegan::scores.rda()}} for the details.}
}
\value{
A data frame (tibble) in long format containing the ordination
scores. The first two components are \code{score} (the type of score in each
row) and \code{label} (the text label to use on plots for this row). The
remaining columns are the extracted ordination axis scores.
}
\description{
Fortifies an object of class \code{"vegan_pco"} to produce a
data frame of the selected axis scores in long format, suitable for
plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)

sol <- pco(dune)
head(fortify(sol))
}
\author{
Gavin L. Simpson
}
