% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg_atlas_data.R
\name{ggseg_data_subcortical}
\alias{ggseg_data_subcortical}
\alias{brain_data_subcortical}
\title{Create subcortical atlas data}
\usage{
ggseg_data_subcortical(sf = NULL, meshes = NULL)

brain_data_subcortical(sf = NULL, meshes = NULL)
}
\arguments{
\item{sf}{sf data.frame with columns label, view, geometry for 2D rendering.
Optional.}

\item{meshes}{data.frame with columns label and mesh (list-column).
Each mesh is a list with:
\itemize{
\item vertices: data.frame with x, y, z columns
\item faces: data.frame with i, j, k columns (1-based triangle indices)
}}
}
\value{
An object of class c("ggseg_data_subcortical", "ggseg_atlas_data")
}
\description{
Creates a data object for subcortical brain atlases. Subcortical atlases
use individual 3D meshes for each structure (e.g., hippocampus, amygdala).
}
\examples{
data <- ggseg_data_subcortical(
  meshes = data.frame(
    label = "hippocampus_left",
    mesh = I(list(list(
      vertices = data.frame(x = 1:10, y = 1:10, z = 1:10),
      faces = data.frame(i = 1:3, j = 2:4, k = 3:5)
    )))
  )
)
}
