% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg_atlas.R
\name{ggseg_atlas}
\alias{ggseg_atlas}
\alias{brain_atlas}
\title{Constructor for ggseg atlas}
\usage{
ggseg_atlas(atlas, type, core, data, palette = NULL)

brain_atlas(atlas, type, core, data, palette = NULL)
}
\arguments{
\item{atlas}{atlas short name, length one}

\item{type}{atlas type: "cortical", "subcortical", or "tract"}

\item{core}{data.frame with required columns hemi, region, label (one row per
unique region). May contain additional columns for grouping or metadata
(e.g., lobe, network, Brodmann area).}

\item{data}{a ggseg_atlas_data object created by
\code{\link[=ggseg_data_cortical]{ggseg_data_cortical()}}, \code{\link[=ggseg_data_subcortical]{ggseg_data_subcortical()}},
or \code{\link[=ggseg_data_tract]{ggseg_data_tract()}}.
Must match the specified type.}

\item{palette}{named character vector of colours keyed by label}
}
\value{
an object of class 'ggseg_atlas'
}
\description{
Creates an object of class 'ggseg_atlas' for plotting brain parcellations
using ggseg (2D) and ggseg3d (3D).
}
\examples{
core <- data.frame(
  hemi = c("left", "left"),
  region = c("region1", "region2"),
  label = c("lh_region1", "lh_region2")
)
vertices <- data.frame(
  label = c("lh_region1", "lh_region2"),
  vertices = I(list(c(1L, 2L, 3L), c(4L, 5L, 6L)))
)
atlas <- ggseg_atlas(
  atlas = "test",
  type = "cortical",
  core = core,
  data = ggseg_data_cortical(vertices = vertices)
)
}
