% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas-utils.R
\name{atlas_manipulation}
\alias{atlas_manipulation}
\alias{atlas_region_remove}
\alias{atlas_region_contextual}
\alias{atlas_region_rename}
\alias{atlas_region_keep}
\alias{atlas_core_add}
\alias{atlas_view_remove}
\alias{atlas_view_keep}
\alias{atlas_view_remove_region}
\alias{atlas_view_remove_small}
\alias{atlas_view_gather}
\alias{atlas_view_reorder}
\title{Manipulate brain atlas regions and views}
\usage{
atlas_region_remove(atlas, pattern, match_on = c("region", "label"))

atlas_region_contextual(atlas, pattern, match_on = c("region", "label"))

atlas_region_rename(atlas, pattern, replacement)

atlas_region_keep(atlas, pattern, match_on = c("region", "label"))

atlas_core_add(atlas, data, by = "region")

atlas_view_remove(atlas, views)

atlas_view_keep(atlas, views)

atlas_view_remove_region(
  atlas,
  pattern,
  match_on = c("label", "region"),
  views = NULL
)

atlas_view_remove_small(atlas, min_area, views = NULL)

atlas_view_gather(atlas, gap = 0.15)

atlas_view_reorder(atlas, order, gap = 0.15)
}
\arguments{
\item{atlas}{A \code{ggseg_atlas} object}

\item{pattern}{Character pattern to match. Uses
\code{grepl(..., ignore.case = TRUE)}.}

\item{match_on}{Column to match against: \code{"region"} or \code{"label"}.}

\item{replacement}{For \code{atlas_region_rename()}: replacement string or
function.}

\item{data}{For \code{atlas_core_add()}: data.frame with metadata to join.}

\item{by}{For \code{atlas_core_add()}: column(s) to join by. Default \code{"region"}.}

\item{views}{For view functions: character vector of view names or
patterns. Multiple values collapsed with \code{"|"} for matching.}

\item{min_area}{For \code{atlas_view_remove_small()}: minimum polygon
area to keep. Context geometries are never removed.}

\item{gap}{Proportional gap between views (default 0.15 = 15\% of max width).}

\item{order}{For \code{atlas_view_reorder()}: character vector of desired
view order. Unspecified views appended at end.}
}
\value{
Modified \code{ggseg_atlas} object
}
\description{
Functions for modifying brain atlas objects. These cover three areas:
}
\details{
\strong{Region manipulation} modifies which regions are active in the atlas:
\itemize{
\item \code{atlas_region_remove()}: completely remove regions
\item \code{atlas_region_contextual()}: keep geometry but remove from core/palette
\item \code{atlas_region_rename()}: rename regions in core
\item \code{atlas_region_keep()}: keep only matching regions
}

\strong{View manipulation} modifies the 2D sf geometry data:
\itemize{
\item \code{atlas_view_remove()}: remove entire views
\item \code{atlas_view_keep()}: keep only matching views
\item \code{atlas_view_remove_region()}: remove specific region geometry from sf
\item \code{atlas_view_remove_small()}: remove small polygon fragments
\item \code{atlas_view_gather()}: reposition views to close gaps
\item \code{atlas_view_reorder()}: change view order
}

\strong{Core manipulation} modifies atlas metadata:
\itemize{
\item \code{atlas_core_add()}: join additional metadata columns
}
}
\section{Functions}{
\itemize{
\item \code{atlas_region_contextual()}: Keep geometry for visual context but remove
from core, palette, and 3D data. Context geometries render grey and don't
appear in legends.

\item \code{atlas_region_rename()}: Rename regions matching a pattern. Only
affects the \code{region} column, not \code{label}. If \code{replacement} is a function,
it receives matched names and returns new names.

\item \code{atlas_region_keep()}: Keep only matching regions. Non-matching
regions are removed from core, palette, and 3D data but sf geometry
is preserved for surface continuity.

\item \code{atlas_core_add()}: Join additional metadata columns to
atlas core.

\item \code{atlas_view_remove()}: Remove views matching pattern from sf data.

\item \code{atlas_view_keep()}: Keep only views matching pattern.

\item \code{atlas_view_remove_region()}: Remove specific region geometry from sf
data only. Core, palette, and 3D data are unchanged.

\item \code{atlas_view_remove_small()}: Remove region geometries below a minimum
area threshold. Context geometries (labels not in core) are never
removed. Optionally scope to specific views.

\item \code{atlas_view_gather()}: Reposition remaining views to close gaps
after view removal.

\item \code{atlas_view_reorder()}: Reorder views and reposition. Views not
in \code{order} are appended at end.

}}
\examples{
dk() |>
  atlas_region_remove("bankssts") |>
  atlas_region_keep("frontal", match_on = "region")

}
