% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_style.R
\name{legend_reverse}
\alias{legend_reverse}
\title{Reverse Legend Order}
\usage{
legend_reverse()
}
\value{
A guides specification that can be added to a plot.
}
\description{
Reverses the order of entries in all legends. Useful when the natural data
order doesn't match the desired visual order (e.g., when stacking bars).
}
\details{
This function applies \code{guide_legend(reverse = TRUE)} to all common
discrete aesthetics: colour, fill, shape, size, linetype, and alpha.
}
\examples{
library(ggplot2)

# Default order
p1 <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point()

# Reversed order
p2 <- p1 + legend_reverse()

}
\seealso{
\code{\link{legend_wrap}}, \code{\link{legend_style}}
}
