% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLSPs.R
\name{makeTRI}
\alias{makeTRI}
\title{makeTRI}
\usage{
makeTRI(
  dtm,
  cellSize = 1,
  roughRadius = 7,
  writeRaster = FALSE,
  outName,
  device = "cpu"
)
}
\arguments{
\item{dtm}{Input SpatRaster object representing bare earth surface elevations.}

\item{cellSize}{Resolution of raster grid. Default is 1 m.}

\item{roughRadius}{radius of circular moving window. Default is 7 cells.}

\item{writeRaster}{TRUE or FALSE. Save output to disk. Default is TRUE.}

\item{outName}{Name of output raster with full file path and extension.}

\item{device}{"cpu" or "cuda". Use "cuda" for GPU computation. Without using the GPU,
implementation will not be significantly faster than using non-tensor-based computation.
Defaults is "cpu".}
}
\description{
Calculate a topographic roughness index (TRI) from a digital terrain model (DTM) using torch
}
\details{
Calculate a topographic roughness index (TPI) from a digital terrain model (DTM) using torch.
Us calculated as the square root of the standard deviation of slope in a local moving window.
Output can be noisy. Radii are specified using cell counts as opposed to map distance.
}
\examples{
\dontrun{
pth <- "OUTPUT PATH"
dtm <- rast(paste0(pth, "dtm.tif"))
tri11 <- makeTRI(dtm,
cellSize=1,
roughRadius=11,
writeRaster=TRUE,
outName=paste0(pth, "tri11f.tif"),
device="cuda")
}
}
