% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.obs.R
\name{plot.obs}
\alias{plot.obs}
\title{Plot observed densities}
\usage{
\method{plot}{obs}(
  x,
  ...,
  dens_2 = NA,
  dens_3 = NA,
  lim = c(-1, 1),
  time_unit = NA,
  combined = TRUE,
  color_actual = "darkgrey",
  color_dens_1 = "#f68f46ff",
  color_dens_2 = "#593d9cff",
  color_dens_3 = "#efe350ff"
)
}
\arguments{
\item{x}{input}

\item{...}{arguments passed on to the function}

\item{dens_2}{density 2 (if any). By default, `NA`.}

\item{dens_3}{density 3 (if any). By default, `NA`.}

\item{lim}{limits of the scale for the average residual fields. By default, c(0, -1). To set limits manually, provide a vector of max and min}

\item{time_unit}{x-axis label of the output}

\item{combined}{whether to combine the two plots. By default, TRUE. If TRUE,
then the plot function produces one ggplot object. If FALSE, three objects (two ggplot and one dataframe) will be produced.}

\item{color_actual}{name of the color for the actual density}

\item{color_dens_1}{name of the color for the predicted density}

\item{color_dens_2}{name of the color for another predicted density (usually for the out-of-sample prediction)}

\item{color_dens_3}{another color for an alternate density for out-of-sample prediction}
}
\description{
Plot observed densities
}
