% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{plot.gctsc}
\alias{plot.gctsc}
\title{Diagnostic Plots for Fitted Gaussian Copula Time Series Models}
\usage{
\method{plot}{gctsc}(
  x,
  caption = rep("", 5),
  main = rep("", 5),
  level = 0.95,
  col.lines = "gray",
  ...
)
}
\arguments{
\item{x}{An object of class \code{gctsc}, the result of a call to \code{\link{gctsc}}.}

\item{caption}{Optional character vector of length 6 to use as captions for each plot.}

\item{main}{Optional main title for the plots (recycled if shorter than the number of plots shown).}

\item{level}{Confidence level for the Q--Q plot envelope (default is 0.95).}

\item{col.lines}{Color for reference lines in residual and ACF/PACF plots.}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
This function is called for its side effects and returns \code{invisible()}.
}
\description{
Produces a set of diagnostic plots based on randomized quantile residuals
and PIT values for objects of class \code{gctsc}.
}
\details{
The function displays up to five plots: time series of residuals, Q--Q plot,
PIT histogram, and ACF/PACF plots of the residuals. These plots help assess
model fit and potential misspecification.

The five diagnostic plots shown are:

\enumerate{
\item Time series plot of randomized quantile residuals.
\item Q--Q plot comparing residuals to a standard normal distribution.
\item Histogram of probability integral transform (PIT) values.
\item Autocorrelation function (ACF) of the residuals.
\item Partial autocorrelation function (PACF) of the residuals.
}
}
\examples{
# Simulate data from a Poisson AR(1) model
set.seed(123)
n <- 2000
mu <- 5
phi <- 0.5
arma_order <- c(1, 0)
y <- sim_poisson(mu = mu, tau = phi, arma_order = arma_order, nsim = n)$y

# Fit the model using the CE method
fit <- gctsc(y~1,
  marginal = poisson.marg(link = "identity", lambda.lower = 0),
  cormat = arma.cormat(p = 1, q = 0),
  method = "CE",
  options = gctsc.opts(seed = 1, M = 1000),
  c = 0.5
)

# Produce diagnostic plots
plot(fit)
}
\seealso{
\code{\link{residuals.gctsc}} for computing the residuals used in the plots.
}
