% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginals.R
\name{marginal.gctsc}
\alias{marginal.gctsc}
\alias{poisson.marg}
\alias{negbin.marg}
\alias{binom.marg}
\alias{zip.marg}
\alias{zib.marg}
\alias{bbinom.marg}
\alias{zibb.marg}
\title{Marginal Models for Copula Time Series}
\usage{
poisson.marg(link = "identity", lambda.lower = NULL, lambda.upper = NULL)

binom.marg(link = "logit", size = NULL, lambda.lower = NULL, lambda.upper = NULL)

zib.marg(link = "logit", size = NULL, lambda.lower = NULL, lambda.upper = NULL)

negbin.marg(link = "identity", lambda.lower = NULL, lambda.upper = NULL)

zip.marg(link = "identity", lambda.lower = NULL, lambda.upper = NULL)

bbinom.marg(link = "logit", size, lambda.lower = NULL, lambda.upper = NULL)

zibb.marg(link = "logit", size,  lambda.lower = NULL, lambda.upper = NULL)
}
\arguments{
\item{link}{The link function for the mean (e.g., \code{"log"}, \code{"logit"}, \code{"identity"}).}

\item{lambda.lower}{Optional lower bounds on parameters.}

\item{lambda.upper}{Optional upper bounds on parameters.}

\item{size}{Number of trials (for binomial-type models).}
}
\value{
A list of class \code{"marginal.gctsc"} representing the marginal model.
}
\description{
The following marginal models are currently available:
\describe{
\item{\code{poisson.marg(link = "log")}}{Poisson distribution.}
\item{\code{negbin.marg(link = "log")}}{Negative binomial distribution.}
\item{\code{binom.marg(link = "logit", size)}}{Binomial distribution with fixed number of trials.}
\item{\code{bbinom.marg(link = "logit", size)}}{Beta-binomial with overdispersion.}
\item{\code{zip.marg(link = "log")}}{Zero-inflated Poisson model.}
\item{\code{zib.marg(link = "logit", size)}}{Zero-inflated binomial.}
\item{\code{zibb.marg(link = "logit", size)}}{Zero-inflated beta-binomial with separate covariates for zero inflation.}
}
}
\details{
These functions define the marginal distributions used in copula-based count time series models.

Each marginal constructor returns an object of class \code{"marginal.gctsc"} which defines:
\itemize{
\item \code{start}: a function to compute starting values.
\item \code{npar}: number of parameters.
\item \code{bounds}: truncation bounds on the latent Gaussian.
}

These marginals are designed to work with \code{gctsc()} and its related methods.
}
\examples{
poisson.marg(link = "identity")
zibb.marg(link = "logit", size = 24)

}
\references{
Cribari-Neto, F. and Zeileis, A. (2010). Beta regression in R. \emph{Journal of Statistical Software}, \strong{34}(2): 1–24.

Ferrari, S.L.P. and Cribari-Neto, F. (2004). Beta regression for modeling rates and proportions. \emph{Journal of Applied Statistics}, \strong{31}(7): 799–815.

Masarotto, G. and Varin, C. (2012). Gaussian copula marginal regression. \emph{Electronic Journal of Statistics}, \strong{6}: 1517–1549.
}
\seealso{
\code{\link{gctsc}}, \code{\link{predict.gctsc}}, \code{\link{arma.cormat}}
}
