% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework_util.R
\name{standardize_wd}
\alias{standardize_wd}
\title{Standardize Working Directory for Framework Projects}
\usage{
standardize_wd(project_root = NULL)
}
\arguments{
\item{project_root}{Character string specifying the project root directory.
If NULL (default), the function will attempt to find it automatically.}
}
\value{
Invisibly returns the standardized project root path.
}
\description{
This function helps standardize the working directory when working with
framework projects, especially useful in Quarto/RMarkdown documents that
may be rendered from subdirectories.
}
\details{
The function looks for common framework project indicators:
\itemize{
\item settings.yml or settings.yml file
\item .Rprofile file
\item Being in common subdirectories (scratch, work)
}

It sets both the regular working directory and knitr's root.dir option
if knitr is available.
}
\examples{
\donttest{
if (FALSE) {
library(framework)
standardize_wd()
scaffold()
}
}

}
