% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_script.R
\name{make_script}
\alias{make_script}
\title{Create an R Script from Stub Template}
\usage{
make_script(name, dir = NULL, stub = "default", overwrite = FALSE)
}
\arguments{
\item{name}{Character. The script name (with or without .R extension).
Examples: "process-data", "process-data.R"}

\item{dir}{Character. Directory to create the script in. Uses your project's
configured \code{directories$scripts} setting. Default: "scripts/".}

\item{stub}{Character. Name of the stub template to use. Defaults to
"default". User can create custom stubs in \verb{stubs/script-\{stub\}.R}.}

\item{overwrite}{Logical. Whether to overwrite existing file. Default FALSE.}
}
\value{
Invisible path to created script
}
\description{
Convenience wrapper for \code{make_notebook()} that creates R scripts (.R files).
This is identical to calling \code{make_notebook("name.R")}.
}
\details{
This function is a convenience wrapper that:
\enumerate{
\item Ensures the name ends with .R extension
\item Uses \code{script_dir} config option instead of \code{notebook_dir}
\item Calls \code{make_notebook()} with \code{type = "script"}
}
\subsection{Default Output}{

Scripts are created in the \verb{scripts/} directory by default:

\if{html}{\out{<div class="sourceCode">}}\preformatted{scripts/
  process-data.R
  build-features.R
  run-model.R
}\if{html}{\out{</div>}}
}
}
\examples{
\donttest{
if (FALSE) {
# Create script (extension optional)
make_script("process-data")
make_script("process-data.R")

# Use custom stub
make_script("etl-pipeline", stub = "etl")

# Create in specific directory
make_script("analysis", dir = "analysis/")
}
}

}
\seealso{
\code{\link[=make_notebook]{make_notebook()}} for creating Quarto/RMarkdown notebooks
}
