% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_notebook.R
\name{make_qmd}
\alias{make_qmd}
\title{Create a Quarto Notebook}
\usage{
make_qmd(name, dir = NULL, stub = "default", overwrite = FALSE, subdir = NULL)
}
\arguments{
\item{name}{Character. The file name (with or without .qmd extension)}

\item{dir}{Character. Directory to create the file in. Uses your project's
configured \code{directories$notebooks} setting. Default: "notebooks/".}

\item{stub}{Character. Name of the stub template to use. Default "default".}

\item{overwrite}{Logical. Whether to overwrite existing file. Default FALSE.}

\item{subdir}{Optional subdirectory under \code{dir} (e.g., "slides/week-01").}
}
\value{
Invisible path to created notebook
}
\description{
Convenient alias for \code{make_notebook(type = "quarto")}. Creates a .qmd file
from stub templates.
}
\examples{
\donttest{
if (FALSE) {
# Create notebooks/analysis.qmd
make_qmd("analysis")

# Use custom stub
make_qmd("report", stub = "minimal")

# Create in specific directory
make_qmd("explore", dir = "work")
}
}

}
\seealso{
\code{\link[=make_notebook]{make_notebook()}}, \code{\link[=make_rmd]{make_rmd()}}
}
