% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plot_data}
\alias{plot_data}
\title{Plot Data Overview}
\usage{
plot_data(
  x,
  col = "steelblue",
  border = "black",
  transparency = 0.5,
  lwd = 2,
  breaks = "Sturges"
)
}
\arguments{
\item{x}{Numeric vector of data.}

\item{col}{Color for plots (default "steelblue").}

\item{border}{Border color for histograms/boxplots (default "black").}

\item{transparency}{Transparency for filled areas (0-1, default 0.5).}

\item{lwd}{Line width for plots (default 2).}

\item{breaks}{Histogram breaks (default "Sturges").}
}
\value{
NULL (plots are drawn)
}
\description{
Generates a 2x2 plot layout showing:
Histogram, Boxplot, Kernel Density, and TTT Plot.
}
\examples{
set.seed(123)
mydata <- rexp(100, 1)
plot_data(mydata, col = "darkblue", transparency = 0.35, lwd = 2)
}
