% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-mw-variability.R
\name{data_mw_variability}
\alias{data_mw_variability}
\title{Estimate Variance for Annual Maximum Series Data}
\usage{
data_mw_variability(data, years, size = 10L, step = 5L)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{size}{Integer scalar. The number of years in each moving window.
Must be a positive number less than or equal to \code{length(data)}
(default is 10).}

\item{step}{Integer scalar. The offset (in years) between successive
moving windows. Must be a positive number (default is 5).}
}
\value{
A list with two entries:
\itemize{
\item \code{years}: Numeric vector containing the mean year within each window.
\item \code{std}: Numeric vector of standard deviations within each window.
}
}
\description{
Generates a time series of standard deviations using a moving window algorithm,
which can be used to explore potential evidence of nonstationarity in the
variability of a dataset. It returns a list that pairs each window’s mean year with
its window standard deviation. The hyperparameters \code{size} and \code{step} control the
behaviour of the moving window. Following the simulation findings from Vidrio-Sahagún
and He (2022), the default window size and step are set to 10 and 5 years
respectively. However, these can be changed by the user.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
data_mw_variability(data, years)

}
\references{
Vidrio-Sahagún, C. T., and He, J. (2022). The decomposition-based nonstationary
flood frequency analysis. Journal of Hydrology, 612 (September 2022), 128186.
\doi{10.1016/j.jhydrol.2022.128186}
}
