% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fauna_pam.R
\name{fauna_pam}
\alias{fauna_pam}
\title{Get a presence-absence matrix}
\usage{
fauna_pam(data, by_state = TRUE, by_country= FALSE,
               remove_empty_sites = TRUE,
               return_richness_summary = TRUE,
               return_spatial_richness = TRUE,
               return_plot = TRUE)
}
\arguments{
\item{data}{(data.frame) a data.frame imported with the
\code{\link{load_faunabr}} function or generated by either
\code{\link{select_fauna}} or \code{\link{subset_fauna}} functions}

\item{by_state}{(logical) get occurrences by State. Default = TRUE}

\item{by_country}{(logical) get occurrences by countries. Default = FALSE}

\item{remove_empty_sites}{(logical) remove empty sites (sites without any
species) from final presence-absence matrix. Default = TRUE}

\item{return_richness_summary}{(logical) return a data.frame with the number
of species in each site. Default = TRUE}

\item{return_spatial_richness}{(logical) return a SpatVector with the number
of species in each site. Default = TRUE}

\item{return_plot}{(logical) plot map with the number of species in each
site.
Only works if return_spatial_richness = TRUE. Default = TRUE}
}
\value{
If return_richness_summary and/or return_spatial_richness is set to
TRUE, return a list with:
\itemize{
\item PAM: the presence-absence matrix (PAM)
\item Richness_summary: a data.frame with the number of species in each site
\item Spatial_richness: a SpatVector with the number of species in each site
(by State and/or country)
}

If return_richness_summary and return_spatial_richness is set to FALSE,
return a presence-absence matrix
}
\description{
Get a presence-absence matrix of species based on its distribution
(brazilian states and/or countries) according to Fauna do Brasil.
}
\examples{
#Test function
data("fauna_data") #Load fauna e Funga do Brasil data
#Select native species of mammals with occurrence only in Brazil
br_mammals <- select_fauna(data = fauna_data,
                           include_subspecies = FALSE, phylum = "all",
                           class = "Mammalia",
                           order = "all", family = "all",
                           genus = "all",
                           lifeForm = "all", filter_lifeForm = "in",
                           habitat = "all", filter_habitat = "in",
                           states = "all", filter_states = "in",
                           country = "BR", filter_country = "only",
                           origin = "all", taxonomicStatus = "valid")
#Get presence-absence matrix in states
pam_mammals <- fauna_pam(data = br_mammals, by_state = TRUE,
                         by_country = FALSE,
                         remove_empty_sites = TRUE,
                         return_richness_summary = TRUE,
                         return_spatial_richness = TRUE,
                         return_plot = TRUE)
}
