% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastFMM.R
\name{new_fastFMMconc}
\alias{new_fastFMMconc}
\title{Create a new "fastFMMconc" object}
\usage{
new_fastFMMconc(
  formula,
  data,
  subj_id,
  argvals,
  family,
  residuals,
  caic,
  randeffs,
  var,
  analytic,
  fun_covariates
)
}
\arguments{
\item{formula}{Formula in `lme4` formula syntax.}

\item{data}{Data frame to fit.}

\item{subj_id}{Character, name of variable containing IDs. Passed from `fui`}

\item{argvals}{List of points to fit on the functional domain. Only applies
for the bootstrap case (i.e., `analytic = FALSE`).}

\item{family}{Character, GLM family of the response. Passed from `fui`.}

\item{residuals}{Logical, indicates whether residuals are saved from
unsmoothed LME. Passed from `fui`.}

\item{caic}{Logical, indicates cAIC calculation return. Defaults to `FALSE`.}

\item{randeffs}{Logical, indicates whether random effect estimates are returned.
Passed from `fui`.}

\item{var}{Logical, indicates whether to calculate variance. Passed from
`fui`.}

\item{analytic}{Logical, indicates whether variance will be calculated
analytically. Passed from `fui`.}

\item{fun_covariates}{Character vector of functional covariate names.}
}
\value{
A "fastFMMconc" object containing parameters to fit a concurrent
mixed model using the FUI scheme. This function is called within `fui` if
indicated by `concurrent = TRUE`. Fields are shared with `fastFMM` objects,
with the addition of `fun_covariates`.
}
\description{
Create an object that contains parameters for fast univariate inference for
concurrent models.
}
