% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{save_clustering_iterations}
\alias{save_clustering_iterations}
\title{Save iteration plots in PDF file}
\usage{
save_clustering_iterations(
  sessions,
  k,
  filename,
  it = 6,
  seeds = round(runif(it, min = 1, max = 1000)),
  plot_scale = 2,
  points_size = 0.25,
  mclust_tol = 1e-08,
  mclust_itmax = 10000,
  log = getOption("evprof.log", FALSE),
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof standard format}

\item{k}{number of clusters}

\item{filename}{string defining the PDF output file path (with extension .pdf)}

\item{it}{number of iterations}

\item{seeds}{seed for each iteration}

\item{plot_scale}{scale of each iteration plot for a good visualization in pdf file}

\item{points_size}{integer, size of points in the scatter plot}

\item{mclust_tol}{tolerance parameter for clustering}

\item{mclust_itmax}{maximum number of iterations}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{start}{integer, start hour in the x axis of the plot.}
}
\value{
nothing, but a PDF file is saved in the path specified by parameter \code{filename}
}
\description{
Save iteration plots in PDF file
}
\examples{
\donttest{
temp_file <- file.path(tempdir(), "iteration.pdf")
save_clustering_iterations(california_ev_sessions, k = 2, it = 4, filename = temp_file)
}


}
