% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_tas.R
\docType{data}
\name{ts_temp}
\alias{ts_temp}
\title{Sample Of Experimental And Observational Climate Time Series Data}
\description{
This sample data contain gridded seasonal forecast and corresponding 
observational data from ECMWF-System 5 forecast system and ERA-5 
reconstruction.
Specifically, for the monthly mean 2-meter temperature ("tas") variable, the
first 3 ensemble members, the first 5 forecast time steps from November 
initial month, year 2000 to 2005, spatial average of the Iberian Peninsula
region (35N-45N, 10W-5E).
}
\details{
The package "startR" is used to load the data from the data esarchive in the
Earth Sciences Department of Barcelona Supercomputing Center 
(check \code{map_temp}). Caclulate the weighted area-mean by function 
\code{ClimProjDiags::WeightedMean}. 

\preformatted{

 # 1. Load data "map_temp" first and load libraries

 library(ClimProjDiags)

 map_temp <- esviz::map_temp
 attrs_exp <- attributes(map_temp$exp)[-1]
 attrs_obs <- attributes(map_temp$obs)[-1]

 # 2. Calculate weighted area mean

 lats <- attr(map_temp$exp, "Variables")$common$lat
 lons <- attr(map_temp$exp, "Variables")$common$lon

 ts_temp <- list()
 ts_temp$exp <- WeightedMean(map_temp$exp, lon = lons, lat = lats)
 ts_temp$obs <- WeightedMean(map_temp$obs, lon = lons, lat = lats)

 attributes(ts_temp$exp) <- c(attributes(ts_temp$exp), attrs_exp)
 attributes(ts_temp$obs) <- c(attributes(ts_temp$obs), attrs_obs)

}
}
