% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizScorecard.R
\name{VizScorecard}
\alias{VizScorecard}
\title{Function to plot Scorecard tables
 
This function renders a scorecard table from a multidimensional array 
in HTML style. The structure of the table is based on the assignment of each 
dimension of the array as a structure element: row, subrow, column or 
subcolumn. It is useful to present tabular results with colors in a nice way.
 
Note: Module PhantomJS is required.}
\usage{
VizScorecard(
  data,
  sign = NULL,
  row_dim = "region",
  subrow_dim = "time",
  col_dim = "metric",
  subcol_dim = "sdate",
  legend_dim = "metric",
  row_names = NULL,
  subrow_names = NULL,
  col_names = NULL,
  subcol_names = NULL,
  row_title = NULL,
  subrow_title = NULL,
  col_title = NULL,
  table_title = NULL,
  table_subtitle = NULL,
  legend_breaks = NULL,
  plot_legend = TRUE,
  label_scale = 1.4,
  legend_width = NULL,
  legend_height = 50,
  palette = NULL,
  colorunder = NULL,
  colorsup = NULL,
  round_decimal = 2,
  font_size = 1.1,
  legend_white_space = 6,
  columns_width = 1.2,
  col1_width = NULL,
  col2_width = NULL,
  fileout = NULL
)
}
\arguments{
\item{data}{A multidimensional array containing the data to be plotted with 
at least four dimensions. Each dimension will have assigned a structure 
element: row, subrow, column and subcolumn.}

\item{sign}{A multidimensional boolean array with the same dimensions as 
'data', indicting which values to be highlighted. If set to NULL no values 
will be highlighted.}

\item{row_dim}{A character string indicating the dimension name to show in the 
rows of the plot. It is set as 'region' by default.}

\item{subrow_dim}{A character string indicating the dimension name to show in 
the sub-rows of the plot. It is set as 'time' by default.}

\item{col_dim}{A character string indicating the dimension name to show in the 
columns of the plot. It is set as 'metric' by default.}

\item{subcol_dim}{A character string indicating the dimension name to show in
the sub-columns of the plot. It is set as 'sdate' by default.}

\item{legend_dim}{A character string indicating the dimension name to use for 
the legend. It is set as 'metric' by default.}

\item{row_names}{A vector of character strings with row display names. It 
is set as NULL by default.}

\item{subrow_names}{A vector of character strings with sub-row display names. 
It is set as NULL by default.}

\item{col_names}{A vector of character strings with column display names. It 
is set as NULL by default.}

\item{subcol_names}{A vector of character strings with sub-column display 
names. It is set as NULL by default.}

\item{row_title}{A character string for the title of the row names. It is set 
as NULL by default.}

\item{subrow_title}{A character string for the title of the sub-row names. It 
is set as NULL by default.}

\item{col_title}{A character string for the title of the column names. It is 
set as NULL by default.}

\item{table_title}{A character string for the title of the plot. It is set as 
NULL by default.}

\item{table_subtitle}{A character string for the sub-title of the plot. It is 
set as NULL by default.}

\item{legend_breaks}{A vector of numerics or a list of vectors of numerics,
containing the breaks for the legends. If a vector is given as input, then 
these breaks will be repeated for each 'legend_dim'. A list of vectors can 
be given as input if the 'legend_dims' require different breaks. This  
parameter is required even if the legend is not plotted, to define the 
colors in the scorecard table. It is set as NULL by default.}

\item{plot_legend}{A logical value to determine if the legend is plotted. It 
is set as TRUE by default.}

\item{label_scale}{A numeric value to define the size of the legend labels. 
It is set as 1.4 by default.}

\item{legend_width}{A numeric value to define the width of the legend bars. By 
default it is set to NULL and calculated internally from the table width.}

\item{legend_height}{A numeric value to define the height of the legend bars. 
It is set as 50 by default.}

\item{palette}{A vector of character strings or a list of vectors of 
character strings containing the colors to use in the legends. If a vector 
is given as input, then these colors will be used for each legend_dim. A 
list of vectors can be given as input if different colors are desired for 
the legend_dims. This parameter must be included even if the legend is 
not plotted, to define the colors in the scorecard table.}

\item{colorunder}{A character string, a vector of character strings or a 
list with single character string elements defining the colors to use for 
data values with are inferior to the lowest breaks value. This parameter 
will also plot a inferior triangle in the legend bar. The parameter can be 
set to NULL if there are no inferior values. If a character string is given 
this color will be applied to all 'legend_dims'. It is set as NULL by 
default.}

\item{colorsup}{A character string, a vector of character strings or a 
list with single character string elements defining the colors to use for 
data values with are superior to the highest breaks value. This parameter 
will also plot a inferior triangle in the legend bar. The parameter can be 
set to NULL if there are no superior values. If a character string is given 
this color will be applied to all legend_dims. It is set as NULL by default.}

\item{round_decimal}{A numeric indicating to which decimal point the data 
is to be displayed in the scorecard table. It is set as 2 by default.}

\item{font_size}{A numeric indicating the font size on the scorecard table. 
Default is 2.}

\item{legend_white_space}{A numeric value defining the initial starting 
position of the legend bars, the white space infront of the legend is 
calculated from the left most point of the table as a distance in cm. The 
default value is 6.}

\item{columns_width}{A numeric value defining the width all columns within the 
table in cm (excluding the first and second columns containing the titles).}

\item{col1_width}{A numeric value defining the width of the first table column
in cm. It is set as NULL by default.}

\item{col2_width}{A numeric value defining the width of the second table 
column in cm. It is set as NULL by default.}

\item{fileout}{A path of the location to save the scorecard plots. By default 
the plots will be saved to the working directory.}
}
\value{
An image file containing the scorecard.
}
\description{
Function to plot Scorecard tables
 
This function renders a scorecard table from a multidimensional array 
in HTML style. The structure of the table is based on the assignment of each 
dimension of the array as a structure element: row, subrow, column or 
subcolumn. It is useful to present tabular results with colors in a nice way.
 
Note: Module PhantomJS is required.
}
\examples{
data <- array(rnorm(1000), dim = c('sdate' = 12, 'metric' = 4, 'region' = 3, 
                                   'time' = 6)) 
row_names <- c('Tropics', 'Extra-tropical NH', 'Extra-tropical SH')
col_names <- c('Mean bias (K)', 'Correlation', 'RPSS','CRPSS')
\donttest{
tmp <- tempfile()
VizScorecard(data = data, row_names = row_names, col_names = col_names, 
             subcol_names =  month.abb[as.numeric(1:12)],
             row_title = 'Region', subrow_title = 'Forecast Month', 
             col_title = 'Start date', 
             table_title = "Temperature of ECMWF System 5", 
             table_subtitle = "(Ref: ERA5 1994-2016)", 
             plot_legend = FALSE, fileout = tmp)
unlink(paste0(tmp, "*"))
}

}
