% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel_info.R
\name{rel_info}
\alias{rel_info}
\title{Marginal Reliability of a Unidimensional IRT Model}
\usage{
rel_info(ip, est)
}
\arguments{
\item{ip}{A data frame or matrix of item parameters with columns in the order
\code{b}, \code{a}, \code{c}, where \code{a} is on the \code{D = 1.702}
metric. If only 1 or 2 columns are supplied, the \code{info()} function is
expected to treat them as 1PL/2PL accordingly.}

\item{est}{A character string specifying the ability estimation method:
\code{"MLE"} for maximum likelihood or \code{"EAP"} for empirical Bayes.}
}
\value{
A single numeric value: the marginal reliability (MLE or EAP,
depending on \code{est}).
}
\description{
Compute marginal reliability for a unidimensional IRT model using either
MLE-based or EAP-based information, via Gaussian quadrature over a
standard normal ability distribution.
}
\details{
Gaussian quadrature with 41 nodes on \code{[-5, 5]} is used to approximate
the integrals.
}
\examples{
data(ip.u)
rel_info(ip.u, "MLE")

}
