% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csem_lord_keats.R
\name{csem_lord_keats}
\alias{csem_lord_keats}
\title{CSEM: Lord Keats Method}
\usage{
csem_lord_keats(x)
}
\arguments{
\item{x}{A data frame or matrix of item responses, with rows as persons
and columns as items. Items are assumed to be dichotomous (0/1).}
}
\value{
A list with:
\describe{
\item{x}{Vector of raw scores from 0 to \code{ni}.}
\item{csem}{Vector of CSEM values under the Lord Keats method.}
}
}
\description{
Compute CSEM using the Lord Keats approach, which rescales Lord's
binomial-model CSEM using empirical KR-20 and KR-21 reliability estimates.
}
\details{
This function first computes Lord's CSEM under the binomial model via
\code{csem_lord(ni)}, where \code{ni = ncol(x)}. It then rescales the
resulting CSEM curve using the ratio
\deqn{
  \sqrt{\frac{1 - \text{KR-20}}{1 - \text{KR-21}}},
}
where KR-20 and KR-21 are computed from the observed data via
\code{kr20(x)} and \code{kr21(x)}, respectively.
}
\examples{
data(data.u)
csem_lord_keats(data.u)

}
