% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prqcQ-data.R
\docType{data}
\name{prqcQ}
\alias{prqcQ}
\title{Ratings on items from the Perceived Relationship Quality Components (PRQC) Inventory from 118 (Q)ueer couples}
\format{
A data frame with 118 rows and 36 variables:
\describe{
\item{prqc.1_1}{Satisfaction item 1 for partner 1}
\item{prqc.1_2}{Satisfaction item 2 for partner 1}
\item{prqc.1_3}{Satisfaction item 3 for partner 1}
\item{prqc.1_4}{Commitment item 1 for partner 1}
\item{prqc.1_5}{Commitment item 2 for partner 1}
\item{prqc.1_6}{Commitment item 3 for partner 1}
\item{prqc.1_7}{Intimacy item 1 for partner 1}
\item{prqc.1_8}{Intimacy item 2 for partner 1}
\item{prqc.1_9}{Intimacy item 3 for partner 1}
\item{prqc.1_10}{Trust item 1 for partner 1}
\item{prqc.1_11}{Trust item 2 for partner 1}
\item{prqc.1_12}{Trust item 3 for partner 1}
\item{prqc.1_13}{Passion item 1 for partner 1}
\item{prqc.1_14}{Passion item 2 for partner 1}
\item{prqc.1_15}{Passion item 3 for partner 1}
\item{prqc.1_16}{Love item 1 for partner 1}
\item{prqc.1_17}{Love item 2 for partner 1}
\item{prqc.1_18}{Love item 3 for partner 1}
\item{prqc.2_1}{Satisfaction item 1 for partner 2}
\item{prqc.2_2}{Satisfaction item 2 for partner 2}
\item{prqc.2_3}{Satisfaction item 3 for partner 2}
\item{prqc.2_4}{Commitment item 1 for partner 2}
\item{prqc.2_5}{Commitment item 2 for partner 2}
\item{prqc.2_6}{Commitment item 3 for partner 2}
\item{prqc.2_7}{Intimacy item 1 for partner 2}
\item{prqc.2_8}{Intimacy item 2 for partner 2}
\item{prqc.2_9}{Intimacy item 3 for partner 2}
\item{prqc.2_10}{Trust item 1 for partner 2}
\item{prqc.2_11}{Trust item 2 for partner 2}
\item{prqc.2_12}{Trust item 3 for partner 2}
\item{prqc.2_13}{Passion item 1 for partner 2}
\item{prqc.2_14}{Passion item 2 for partner 2}
\item{prqc.2_15}{Passion item 3 for partner 2}
\item{prqc.2_16}{Love item 1 for partner 2}
\item{prqc.2_17}{Love item 2 for partner 2}
\item{prqc.2_18}{Love item 3 for partner 2}

}
}
\usage{
data(prqcQ)
}
\description{
A data set containing ratings on items (3 each) assessing romantic: (1) satisfaction, (2) commitment, (3) intimacy,
(4) trust, (5) passion, and (6) love for each member of a dyad in which one or more members identify as LGBTQ+.
Perceived Relationship Quality Components (PRQC) Inventory (Fletcher, Simpson, & Thomas, 2000).
Data are from Sakaluk, Fisher, and Kilshaw (2021).
Variable names follow a stem-partner-item ("spi") order, with a delimiter (".") between
the stem and distinguishing partner character, and another delimiter ("_") between the
distinguishing partner character and item number.
}
\references{
Sakaluk, J. K., Fisher, A. N., & Kilshaw, R. E.(2021). Dyadic measurement invariance and its importance for replicability in romantic relationship research. \emph{Personal Relationships}, \emph{28}(1), 190-226.  .#'
}
\keyword{datasets}
