% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc-data.R
\docType{data}
\name{aesi}
\alias{aesi}
\title{Adverse Events of Special Interest (AESI) example dataset}
\format{
A \code{data.frame} with a subset of rows from \code{cadae} and additional
derived columns including:
\describe{
\item{FATAL}{Logical flag for fatal AEs (\code{AESDTH == "Y"}).}
\item{SEV}{Logical flag for severe AEs (\code{AESEV == "SEVERE"}).}
\item{SER}{Logical flag for serious AEs (\code{AESER == "Y"}).}
\item{SERWD}{Serious AE leading to withdrawal (\code{AESER == "Y" & AEACN == "DRUG WITHDRAWN"}).}
\item{SERDSM}{Serious AE leading to dose modification/interruption.}
\item{RELSER}{Serious and related AE.}
\item{WD}{AE leading to withdrawal.}
\item{DSM}{AE leading to dose modification/interruption.}
\item{REL}{Related AE.}
\item{RELWD}{Related AE leading to withdrawal.}
\item{RELDSM}{Related AE leading to dose modification/interruption.}
}
}
\usage{
aesi
}
\description{
\link{aesi} is a modified version of the \link[random.cdisc.data:cadae]{random.cdisc.data::cadae} dataset,
filtered to include only analysis-flagged records (\code{ANL01FL == "Y"}) and
extended with binary indicator variables corresponding to adverse events of
special interest (AESIs).
}
\details{
These derived flags include seriousness, severity, fatality, relatedness, and
treatment consequence (e.g., dose modification or withdrawal), and are used to
illustrate key safety summaries in clinical reporting.

Each derived variable is labeled using \code{\link[=with_label]{with_label()}} for compatibility
with tabulation functions.

This dataset is included in \code{{dtlg}} to support function testing, usage
examples, and reproducible safety analyses.
}
\examples{
aesi

}
\seealso{
\link[random.cdisc.data:cadae]{random.cdisc.data::cadae}, \code{\link[=multi_event_true]{multi_event_true()}}
}
\keyword{datasets}
