% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_dtGAP.R
\name{save_dtGAP}
\alias{save_dtGAP}
\title{Save dtGAP Visualization to File}
\usage{
save_dtGAP(
  file,
  format = NULL,
  width = 297,
  height = 210,
  dpi = 300,
  bg = "white",
  ...
)
}
\arguments{
\item{file}{Character. Output file path. The format is inferred from the
file extension unless \code{format} is specified explicitly.}

\item{format}{Character or NULL. One of \code{"png"}, \code{"pdf"}, or
\code{"svg"}. If NULL (default), inferred from \code{file} extension.}

\item{width}{Numeric. Page width in mm (default 297, A4 landscape).}

\item{height}{Numeric. Page height in mm (default 210, A4 landscape).}

\item{dpi}{Numeric. Resolution for PNG output (default 300). Ignored for
PDF and SVG.}

\item{bg}{Character. Background color (default \code{"white"}).}

\item{...}{Additional arguments passed to \code{\link{dtGAP}()}.}
}
\value{
Invisible file path of the created file.
}
\description{
Exports the dtGAP plot to PNG, PDF, or SVG format.
}
\examples{
\donttest{
save_dtGAP(
  file = tempfile(fileext = ".png"),
  data_train = train_covid,
  data_test = test_covid,
  target_lab = "Outcome",
  show = "test",
  print_eval = FALSE
)
}
}
