% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{apply}
\alias{apply}
\alias{apply.default}
\alias{apply.tbl_ddf}
\alias{apply.ddf_col}
\title{Apply functions over array margins}
\usage{
apply(X, MARGIN, FUN, ...)

\method{apply}{default}(X, MARGIN, FUN, ..., simplify = TRUE)

\method{apply}{tbl_ddf}(X, MARGIN, FUN, ...)

\method{apply}{ddf_col}(X, MARGIN, FUN, ...)
}
\arguments{
\item{X}{A dibble or array, including a matrix.}

\item{MARGIN}{An integer or character vector giving the subscripts which the
function will be applied over.}

\item{FUN}{A function to be applied.}

\item{...}{Optional arguments to FUN.}

\item{simplify}{A logical indicating whether results should be simplified if
possible.}
}
\value{
A dibble if X is a dibble. See \code{\link[base:apply]{base::apply()}} for the return value
of the default method.
}
\description{
Applying a function to margins of a dibble or array, including a matrix.
}
\details{
\code{apply()} overrides \code{\link[base:apply]{base::apply()}} to make it generic. The default method
calls the base version.
}
\examples{
x <- array(1:24, 2:4,
           list(axis1 = letters[1:2],
                axis2 = letters[1:3],
                axis3 = letters[1:4]))

apply(x, 2:3, sum)
apply(as_dibble(x), 2:3, sum)

apply(x, c("axis2", "axis3"), sum)
apply(as_dibble(x), c("axis2", "axis3"), sum)

}
\seealso{
\code{\link[base:apply]{base::apply()}}.
}
