% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_stat_p.R
\name{sum_stat_p}
\alias{sum_stat_p}
\title{Summarize Continuous and Categorical Variables with Grouping and P-Values}
\usage{
sum_stat_p(data, by, statistic = "mean_sd", test_type = "auto", paired = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble} containing the variables to summarize.}

\item{by}{A string specifying the grouping variable for stratified summaries.}

\item{statistic}{Character string indicating how to summarize continuous variables:
\code{"mean_sd"} (default) or \code{"med_iqr"}.}

\item{test_type}{Character string specifying the statistical test for group comparisons:
\code{"auto"} (default, chooses test based on data), \code{"t.test"}, \code{"wilcox"}, \code{"anova"},
\code{"kruskal"}, \code{"chisq"}, or \code{"fisher"}.}

\item{paired}{Logical. If TRUE and only two groups exist, performs a paired t-test for continuous variables. Default is FALSE.}
}
\value{
A \code{flextable} object displaying a publication-ready summary table including:
\itemize{
\item Counts and percentages for categorical variables
\item Mean (SD) or median (IQR) for continuous variables
\item P-values for group comparisons
\item Footnotes describing which summary statistics and tests were used
}
}
\description{
\code{sum_stat_p} generates a descriptive summary table for both continuous and categorical variables,
stratified by a grouping variable. It automatically computes appropriate statistical tests
(Chi-square, Fisher's exact, t-test, Wilcoxon, ANOVA, or Kruskal–Wallis) based on variable type,
number of groups, and data distribution. Continuous variables can be summarized as mean (SD) or median (IQR),
and categorical variables as counts and percentages.
}
\details{
The output is formatted as a \code{flextable} with footnotes indicating which summary statistics
were used and which statistical tests were applied.
}
\examples{
# Summary of iris dataset by species
sum_stat_p(iris, by = "Species", statistic = "mean_sd", test_type = "auto")

# Summary of CO2 dataset by Type with paired t-test
sum_stat_p(CO2, by = "Type", statistic = "mean_sd", test_type = "t.test", paired = TRUE)

# Summary using median and IQR
sum_stat_p(iris, by = "Species", statistic = "med_iqr", test_type = "kruskal")
}
