% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dri_ind.R
\name{get_dri_ind}
\alias{get_dri_ind}
\title{Get DRI from Individual Participants}
\usage{
get_dri_ind(ic, adjusted = TRUE)
}
\arguments{
\item{ic}{dataframe generated by \code{get_dri_ic(data)}}

\item{adjusted}{a logical indicating whether to use the original or adjusted
DRI calculation formula}
}
\value{
tibble with \code{pnum} as participant number and their respective
individual \code{dri}
}
\description{
\code{get_dri_ind} calculates the DRI for each individual participant at a
deliberation
}
\examples{

# get post-deliberation (stage_id == 2) data from Zukunft case
data <- human_data[human_data$stage_id == 2 & human_data$case == "Zukunft", ]

# generate IC
ic <- get_dri_ic(data)

# get individual DRIs
get_dri_ind(ic)

}
\seealso{
\code{\link[=get_dri_ic]{get_dri_ic()}} to generate \code{ic} parameter

Other IC methods: 
\code{\link{get_dri}()}
}
\concept{IC methods}
