% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dri_case.R
\name{get_dri_case}
\alias{get_dri_case}
\title{Get DRI from Case}
\usage{
get_dri_case(
  case,
  adjusted = TRUE,
  method = "wilcox",
  alternative = "greater",
  data = NULL
)
}
\arguments{
\item{case}{a character string specifying the name of the case in human_data}

\item{adjusted}{a logical indicating whether you want the original or adjusted
DRI formula}

\item{method}{a character string specifying the method for statistical testing,
must be one of "wilcox" (default) or "t.test"}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "greater" (default), "two.sided" or "less".
You can specify just the initial letter}

\item{data}{a survey responses dataframe, must include pre-
(\code{stage_id == 1}) and post-deliberation (\code{stage_id == 2}) data}
}
\value{
a tibble with with the following components: \code{case}, \code{pre},
\code{post}, \code{delta}, \code{p_value}, and \code{significance}
}
\description{
\code{get_dri_case} calculates the pre- and post-deliberation DRI from a specific
deliberation case
}
\examples{

get_dri_case("Activate")

# same as
get_dri_case("Activate", data = human_data)

}
\seealso{
\link{human_data} for raw survey response data formatting

Other DRI survey methods: 
\code{\link{get_dri_alpha}()},
\code{\link{get_dri_ic}()}
}
\concept{DRI survey methods}
