% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-stan-data.R
\name{stan_data}
\alias{stan_data}
\title{Create a list of data objects for 'Stan'}
\usage{
stan_data(x, ...)
}
\arguments{
\item{x}{An object (e.g., a \link[=dcm_specify]{model specification}) to create
a data list for.}

\item{...}{Additional arguments passed to methods. See details.}
}
\value{
A list of data objects.
}
\description{
When using 'Stan' to estimate a model, data objects must be passed as a list,
where the name each object corresponds to the name of a variable in the
\code{data} block of the 'Stan' code. \code{stan_data()} creates the list of data
objects needed to estimate the model, consistent with the \code{data} block
generated by \code{\link[=stan_code]{stan_code()}}.
}
\details{
Arguments for \link[=dcm_specify]{model specification} method:
\itemize{
\item \code{data}: The response data. A data frame with 1 row per respondent and 1
column per item. May optionally include an additional column of item
identifiers. If an identifier is included, this should be specified with
\code{identifier}. All cells for the remaining item columns should be either 0
(incorrect response) or 1 (correct response).
\item \code{missing}: An expression specifying how missing values in \code{data} are
encoded (e.g., \code{NA}, \code{"."}, \code{-99}). The default is \code{NA}.
\item \code{identifier}: Optional. If present, the quoted name of the column in
\code{data} that contains respondent identifiers.
}

Arguments for \link[=generated_quantities]{generated quantities} method:
\itemize{
\item \code{dcm_spec}: A cleaned data object, as returned by
\code{\link[rdcmchecks:check_data]{rdcmchecks::clean_data()}}.
\item \code{data}: The response data. A data frame with 1 row per respondent and 1
column per item. May optionally include an additional column of item
identifiers. If an identifier is included, this should be specified with
\code{identifier}. All cells for the remaining item columns should be either 0
(incorrect response) or 1 (correct response).
\item \code{missing}: An expression specifying how missing values in \code{data} are
encoded (e.g., \code{NA}, \code{"."}, \code{-99}). The default is \code{NA}.
\item \code{identifier}: Optional. If present, the quoted name of the column in
\code{data} that contains respondent identifiers.
}
}
\examples{
qmatrix <- data.frame(
  att1 = sample(0:1, size = 5, replace = TRUE),
  att2 = sample(0:1, size = 5, replace = TRUE)
)
data <- data.frame(
  item_1 = sample(0:1, size = 20, replace = TRUE),
  item_2 = sample(0:1, size = 20, replace = TRUE),
  item_3 = sample(0:1, size = 20, replace = TRUE),
  item_4 = sample(0:1, size = 20, replace = TRUE),
  item_5 = sample(0:1, size = 20, replace = TRUE)
)

model_spec <- dcm_specify(qmatrix = qmatrix,
                          measurement_model = lcdm(),
                          structural_model = unconstrained())

stan_data(model_spec, data = data)
}
