# R/data.R
#' Political Linguistics Museum Data
#'
#' A data frame containing 13 famous digital gaffes and typos from political figures.
#'
#' @format A data frame with 13 rows and 8 variables:
#' \describe{
#'   \item{id}{Unique identifier for the gaffe}
#'   \item{original}{The intended word or phrase}
#'   \item{gaffe}{The actual typo or gaffe}
#'   \item{person}{The person who made the gaffe}
#'   \item{year}{Year the gaffe occurred}
#'   \item{platform}{Platform where the gaffe appeared (Twitter, Truth Social, etc.)}
#'   \item{typo_type}{Classification of the typo type}
#'   \item{context}{Brief description of the context}
#' }
#' @source Various news sources and social media archives
"gaffes"

#' QWERTY Keyboard Layout Data
#'
#' A list containing row and column positions for each letter on a QWERTY keyboard.
#'
#' @format A named list with 26 elements (a-z), each containing a named numeric
#'   vector with 'row' and 'col' positions.
"qwerty_layout"

#' QWERTY Keyboard Adjacency Data
#'
#' A list containing adjacent keys for each letter on a QWERTY keyboard.
#'
#' @format A named list with 26 elements (a-z), each containing a character
#'   vector of adjacent key letters.
"qwerty_adjacency"

#' Phonetic Consonant Groups
#'
#' Consonants grouped by place of articulation.
#'
#' @format A named list with groups: labial, dental, velar, sibilant, liquid, glide.
"phonetic_groups"

#' Phonetically Similar Consonant Pairs
#'
#' Pairs of consonants that are phonetically similar and commonly confused.
#'
#' @format A named list mapping consonants to their phonetically similar pairs.
"consonant_pairs"

#' Vowel Shift Mappings
#'
#' Possible vowel shifts inspired by historical sound changes.
#'
#' @format A named list mapping vowels to possible shift targets.
"vowel_shifts"

#' Soundex Encoding Map
#'
#' Mapping of consonants to their Soundex digit codes.
#'
#' @format A named character vector mapping consonants to digits 1-6.
"soundex_map"

# Suppress R CMD check notes for data variables
utils::globalVariables(c(
  "gaffes", "qwerty_layout", "qwerty_adjacency",
  "phonetic_groups", "consonant_pairs", "vowel_shifts", "soundex_map"
))
