% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_idiomatic.R
\name{.cstr_apply}
\alias{.cstr_apply}
\title{.cstr_apply}
\usage{
.cstr_apply(
  args,
  fun = "list",
  ...,
  trailing_comma = FALSE,
  recurse = TRUE,
  implicit_names = FALSE,
  new_line = TRUE,
  one_liner = FALSE,
  unicode_representation = c("ascii", "latin", "character", "unicode"),
  escape = FALSE
)
}
\arguments{
\item{args}{A list of arguments to construct recursively, or code if \code{recurse = FALSE}.
If elements are named, the arguments will be named in the generated code.}

\item{fun}{The function name to use to build code of the form "fun(...)"}

\item{...}{Options passed recursively to the further methods}

\item{trailing_comma}{Boolean. Whether to leave a trailing comma after the last argument if
the code is multiline, some constructors allow it (e.g. \code{tibble::tibble()}) and it makes for nicer
diffs in version control.}

\item{recurse}{Boolean. Whether to recursively generate the code to construct \code{args}. If \code{FALSE} arguments
are expected to contain code.}

\item{implicit_names}{When data is provided, compress calls of the form \code{f(a = a)} to \code{f(a)}}

\item{new_line}{Boolean. Forwarded to \code{wrap()} to add a line between "fun(" and ")", forced to
\code{FALSE} if \code{one_liner} is \code{TRUE}}

\item{one_liner}{Boolean. Whether to return a one line call.}

\item{unicode_representation}{By default "ascii", which means only ASCII characters
(code point < 128) will be used to construct strings and variable names. This makes sure that
homoglyphs (different spaces and other identically displayed unicode characters)
are printed differently, and avoid possible unfortunate copy and paste
auto conversion issues. "latin" is more lax and uses all latin characters
(code point < 256). "character" shows all characters, but not emojis. Finally
"unicode" displays all characters and emojis, which is what \code{dput()} does.}

\item{escape}{Boolean. Whether to escape double quotes and backslashes. If \code{FALSE} we use
single quotes to surround strings (including variable and element names)
containing double quotes, and raw strings for strings that contain backslashes
and/or a combination of single and double quotes. Depending on
\code{unicode_representation} \code{escape = FALSE} cannot be applied on all strings.}
}
\value{
A character vector of code
}
\description{
Exported for custom constructor design. If \code{recurse} is \code{TRUE} (default), we
recurse to construct \code{args} and insert their construction code in a \code{fun(...)} call returned
as a character vector. If \code{args} already contains code rather than object to
construct one should set \code{recurse} to \code{FALSE}.
}
\examples{
a <- 1
.cstr_apply(list(a=a), "foo")
.cstr_apply(list(a=a), "foo", data = list(a=1))
.cstr_apply(list(a=a), "foo", data = list(a=1), implicit_names = TRUE)
.cstr_apply(list(b=a), "foo", data = list(a=1), implicit_names = TRUE)
.cstr_apply(list(a="c(1,2)"), "foo")
.cstr_apply(list(a="c(1,2)"), "foo", recurse = FALSE)
}
