% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getDataCont}
\alias{getDataCont}
\title{Get Continuous Data}
\usage{
getDataCont(arm, resprate, dist = "norm")
}
\arguments{
\item{arm}{Arm allocation for a single patient. Expects number in \emph{1,2,...,n} where \emph{n} is the number of treatment arms including control.}

\item{resprate}{Response rates for each arm. Expects a list of n lists with the first list containing
median and standard deviation paramaterizing control response. Expects \code{c(mean, sd)} for each arm.}

\item{dist}{Type of distribution. Default is normal (\code{norm}).}
}
\value{
Returns a continuous value corresponding to patient response.
}
\description{
Given an arm allocation and response rates, this function generates response from a given distribution.
}
\examples{
response <- getDataCont(1, list(control = c(0,1), treatment = c(0.5,1)), dist='norm')
}
