% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{divdif}
\alias{divdif}
\title{Divided differences}
\usage{
divdif(x, f)
}
\arguments{
\item{x}{A vector of real numbers. Grid points corresponding to the tabulated
(known) values of the function.}

\item{f}{A vector of real numbers. Tabulated (known) values of the function, 
corresponding to the grid \code{x}.}
}
\value{
A matrix of size n X n, where n is the length of \code{x}. Each column
of this matrix contains the divided differences at a specified level. Thus, column
1 contains the level 1 values, i.e. the n tabulated points, column 2 contains the
n-1 divided differences calculated with the adjacent couples of grid points,
column 3 contains all n-2 level 3 divided differences, and so on. In each column
the remaining slots (no slots in the first column, one slot in the second column,
two slots in the third column, etc) are filled with zeros.
}
\description{
Calculation of all the n*(n+1)/2 divided differences related to n tabulated
points of a function. The values returned fill half of a n X n matrix, the other
half being filled with zeros.
}
\examples{
# Tabulated values: f(x)=x^3-4x^2+3x+2
x <- c(-1,1,2,4)
f <- c(-6,2,0,14)

# Matrix filled with divided differences and zeros
P <- divdif(x,f)
print(P)

# Add two tabulated points to previous set
x <- c(x,0,3)
f <- c(f,2,2)

# New divided differences appear, but
# the old ones are unchanged
P <- divdif(x,f)
print(P)

}
