% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_cramer.R
\name{score_cramer}
\alias{score_cramer}
\title{Compute Cramer's V between categorical observations and predictions}
\usage{
score_cramer(o = NULL, p = NULL, ...)
}
\arguments{
\item{o}{(required; character vector) categorical observations. Default: NULL}

\item{p}{(required; character vector) categorical predictions. Default: NULL}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
numeric: Cramer's V
}
\description{
Internal function to compute the Cramer's V of categorical observations versus categorical model predictions. Please read the help file of \code{\link[=cor_cramer]{cor_cramer()}} for further details.
}
\examples{
score_cramer(
 o = c("a", "a", "b", "c", "c"),
 p = c("a", "b", "b", "c", "c")
 )

}
\seealso{
Other modelling_tools: 
\code{\link{case_weights}()},
\code{\link{model_formula}()},
\code{\link{score_auc}()},
\code{\link{score_r2}()}
}
\concept{modelling_tools}
