% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_cramer.R
\name{cor_cramer}
\alias{cor_cramer}
\title{Quantify association between categorical variables}
\usage{
cor_cramer(x = NULL, y = NULL, check_input = TRUE, ...)
}
\arguments{
\item{x}{(required; vector) Values of a categorical variable (character or vector). Converted to character if numeric or logical. Default: NULL}

\item{y}{(required; vector) Values of a categorical variable (character or vector). Converted to character if numeric or logical. Default: NULL}

\item{check_input}{(required; logical) If FALSE, disables data checking for a slightly faster execution. Default: TRUE}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
numeric: Cramer's V
}
\description{
Cramer's V extends the chi-squared test to quantify how strongly the categories of two variables co-occur. The value ranges from 0 to 1, where 0 indicates no  association and 1 indicates perfect association.

This function implements a bias-corrected version of Cramer's V, which adjusts for sample size and is more accurate for small samples. However, this bias correction means that even for binary variables, Cramer's V will no equal the Pearson correlation (the standard, uncorrected Cramer's V does match Pearson for binary data).

As the number of categories increases, Cramer's V and Pearson correlation measure increasingly different aspects of association and should not be directly compared.

If you intend to combine these measures in a multicollinearity analysis, interpret them with care. It is often preferable to convert non-numeric variables to numeric form (for example, via target encoding) before assessing multicollinearity.
}
\examples{

# perfect one-to-one association
cor_cramer(
  x = c("a", "a", "b", "c"),
  y = c("a", "a", "b", "c")
)

# still perfect: labels differ but mapping is unique
cor_cramer(
  x = c("a", "a", "b", "c"),
  y = c("a", "a", "b", "d")
)

# high but < 1: mostly aligned, one category of y repeats
cor_cramer(
  x = c("a", "a", "b", "c"),
  y = c("a", "a", "b", "b")
)

# appears similar by position, but no association by distribution
# (x = "a" mixes with y = "a" and "b")
cor_cramer(
  x = c("a", "a", "a", "c"),
  y = c("a", "a", "b", "b")
)

# numeric inputs are coerced to character internally
cor_cramer(
  x = c(1, 1, 2, 3),
  y = c(1, 1, 2, 2)
)

# logical inputs are also coerced to character
cor_cramer(
  x = c(TRUE, TRUE, FALSE, FALSE),
  y = c(TRUE, TRUE, FALSE, FALSE)
)

}
\references{
\itemize{
\item Cramér, H. (1946). Mathematical Methods of Statistics. Princeton: Princeton University Press, page 282 (Chapter 21. The two-dimensional case). ISBN 0-691-08004-6
}
}
\seealso{
Other multicollinearity_assessment: 
\code{\link{collinear_stats}()},
\code{\link{cor_clusters}()},
\code{\link{cor_df}()},
\code{\link{cor_matrix}()},
\code{\link{cor_stats}()},
\code{\link{vif}()},
\code{\link{vif_df}()},
\code{\link{vif_stats}()}
}
\author{
Blas M. Benito, PhD
}
\concept{multicollinearity_assessment}
