% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coglasso.R
\encoding{UTF-8}
\name{coglasso}
\alias{coglasso}
\title{Estimate networks from a multi-omics data set}
\usage{
coglasso(
  data,
  p = NULL,
  pX = lifecycle::deprecated(),
  lambda_w = NULL,
  lambda_b = NULL,
  c = NULL,
  nlambda_w = NULL,
  nlambda_b = NULL,
  nc = NULL,
  lambda_w_max = NULL,
  lambda_b_max = NULL,
  c_max = NULL,
  lambda_w_min_ratio = NULL,
  lambda_b_min_ratio = NULL,
  c_min = NULL,
  icov_guess = NULL,
  cov_output = FALSE,
  lock_lambdas = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{The input multi-omics data set. Rows should be samples, columns
should be variables. Variables should be grouped by their assay (e.g.
transcripts first, then metabolites). \code{data} is a required parameter.}

\item{p}{A vector with with the number of variables for each omic layer of the
data set (e.g. the number of transcripts, metabolites etc.), in the same
order the layers have in the data set. If given a single number,
\code{coglasso()} assumes that the total of data sets is two, and that the
number given is the dimension of the first one.}

\item{pX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{pX} is no longer supported.
Please use \code{p}.}

\item{lambda_w}{A vector of values for the parameter \eqn{\lambda_w}, the
penalization parameter for the "within" interactions. Overrides
\code{nlambda_w}.}

\item{lambda_b}{A vector of values for the parameter \eqn{\lambda_b}, the
penalization parameter for the "between" interactions. Overrides
\code{nlambda_b}.}

\item{c}{A vector of values for the parameter \eqn{c}, the weight given to
collaboration. Overrides \code{nc}.}

\item{nlambda_w}{The number of requested \eqn{\lambda_w} parameters to
explore. A sequence of size \code{nlambda_w} of \eqn{\lambda_w} parameters will
be generated. Defaults to 8. Ignored when \code{lambda_w} is set by the user.}

\item{nlambda_b}{The number of requested \eqn{\lambda_b} parameters to
explore. A sequence of size \code{nlambda_b} of \eqn{\lambda_b} parameters will
be generated. Defaults to 8. Ignored when \code{lambda_b} is set by the user.}

\item{nc}{The number of requested \eqn{c} parameters to explore. A sequence
of size \code{nc} of \eqn{c} parameters will be generated. Defaults to 5.
Ignored when \code{c} is set by the user.}

\item{lambda_w_max}{The greatest generated \eqn{\lambda_w}. By default it is
computed with a data-driven approach. Ignored when \code{lambda_w} is set by the
user.}

\item{lambda_b_max}{The greatest generated \eqn{\lambda_b}. By default it is
computed with a data-driven approach. Ignored when \code{lambda_b} is set by the
user.}

\item{c_max}{The greatest \eqn{c} explored. Defaults to 100. Ignored when \code{c}
is set by the user.}

\item{lambda_w_min_ratio}{The ratio of the smallest generated \eqn{\lambda_w}
over the greatest generated \eqn{\lambda_w}. Defaults to 0.1. Ignored when
\code{lambda_w} is set by the user.}

\item{lambda_b_min_ratio}{The ratio of the smallest generated \eqn{\lambda_b}
over the greatest generated \eqn{\lambda_b}. Defaults to 0.1. Ignored when
\code{lambda_b} is set by the user.}

\item{c_min}{The the smallest \eqn{c} explored. Defaults to
\eqn{\frac{1}{c_{max}}}, so to 0.01 if \code{c_max} is not set by the user.
Ignored when \code{c} is set by the user.}

\item{icov_guess}{Use a predetermined inverse covariance matrix as an initial
guess for the network estimation.}

\item{cov_output}{Add the estimated variance-covariance matrix to the output.}

\item{lock_lambdas}{Set \eqn{\lambda_w = \lambda_b}. Force a single lambda
parameter for both "within" and "between" interactions.}

\item{verbose}{Print information regarding current \code{coglasso} run on the
console.}
}
\value{
\code{coglasso()} returns an object of \code{S3} class \code{coglasso}, that has the
following elements:
\itemize{
\item \code{loglik} is a numerical vector containing the \eqn{log} likelihoods of all
the estimated networks.
\item \code{density} is a numerical vector containing a measure of the density of all
the estimated networks.
\item \code{df} is an integer vector containing the degrees of freedom of all the
estimated networks.
\item \code{convergence} is a binary vector containing whether a network was
successfully estimated for the given combination of hyperparameters or not.
\item \code{path} is a list containing the adjacency matrices of all the estimated
networks.
\item \code{icov} is a list containing the inverse covariance matrices of all the
estimated networks.
\item \code{nexploded} is the number of combinations of hyperparameters for which
\code{coglasso()} failed to converge.
\item \code{data} is the input multi-omics data set.
\item \code{hpars} is the ordered table of all the combinations of hyperparameters
given as input to \code{coglasso()}, with \eqn{\alpha(\lambda_w+\lambda_b)}
being the key to sort rows.
\item \code{lambda_w} is a numerical vector with all the \eqn{\lambda_w} values \code{coglasso()}
used.
\item \code{lambda_b} is a numerical vector with all the \eqn{\lambda_b} values \code{coglasso()}
used.
\item \code{c} is a numerical vector with all the \eqn{c} values \code{coglasso()}
used.
\item \code{p} is the vector with the number of variables for each omic layer of the
data set.
\item \code{D} is the number of omics layers in the data set.
\item \code{icov_guess} optional, returned when \code{icov_guess} is given. It is the
predetermined inverse covariance matrix  given by the user as an initial
guess for the network estimation.
\item \code{cov} optional, returned when \code{cov_output} is TRUE, is a list containing
the variance-covariance matrices of all the estimated networks.
\item \code{call} is the matched call.
}
}
\description{
\code{coglasso()} estimates multiple multi-omics networks with the algorithm
\emph{collaborative graphical lasso}, one for each combination of input values for
the hyperparameters \eqn{\lambda_w}, \eqn{\lambda_b} and \eqn{c}.
}
\examples{
# Typical usage: set the number of hyperparameters to explore
cg <- coglasso(multi_omics_sd_micro,
  p = c(4, 2), nlambda_w = 3,
  nlambda_b = 3, nc = 3, verbose = FALSE
)
\donttest{
# Model selection using eXtended Efficient StARS, takes less than five seconds
sel_cg_xestars <- select_coglasso(cg, method = "xestars", verbose = FALSE)
}

}
