\name{timi_stemi_score}
\alias{timi_stemi_score}
\title{
TIMI Risk Score for STEMI
}
\description{
Calculates the TIMI Risk Score for ST-Elevation Myocardial Infarction (STEMI). This score estimates 30-day mortality in patients presenting with STEMI based on clinical characteristics available at admission.
}
\usage{
timi_stemi_score(age, history_diabetes_htn_angina, systolic_bp, heart_rate,
                 killip_class_2_to_4, weight_kg, anterior_ste_or_lbbb,
                 time_to_treatment_gt_4h)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
Scoring: <65 (0), 65-74 (2), >=75 (3).
}
  \item{history_diabetes_htn_angina}{
Numeric (0 or 1). History of Diabetes, Hypertension, or Angina. (1 = Yes, +1 point).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (<100 mmHg adds 3 points).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>100 bpm adds 2 points).
}
  \item{killip_class_2_to_4}{
Numeric (0 or 1). Killip Class II-IV (evidence of heart failure like jugular venous distention, rales, or pulmonary edema). (1 = Yes, +2 points).
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms. (<67 kg adds 1 point).
}
  \item{anterior_ste_or_lbbb}{
Numeric (0 or 1). Anterior ST-segment elevation or Left Bundle Branch Block (LBBB) on ECG. (1 = Yes, +1 point).
}
  \item{time_to_treatment_gt_4h}{
Numeric (0 or 1). Time to treatment > 4 hours. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{TIMI_Score}{The calculated risk score (Range 0-14).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality percentage based on the score.}
}
\references{
Morrow DA, Antman EM, Charlesworth A, et al. TIMI risk score for ST-elevation myocardial infarction: A convenient, bedside, clinical score for risk assessment at presentation: An intravenous nPA for treatment of infarcting myocardium early II trial substudy. Circulation. 2000;102(17):2031-2037. doi:10.1161/01.cir.102.17.2031
}
\examples{

# Example 1: High Risk
# 76yo (+3), Hx HTN (+1), SBP 90 (+3), HR 110 (+2), Killip III (+2), 80kg, Ant STE (+1), Time <4h
# Score = 3 + 1 + 3 + 2 + 2 + 0 + 1 + 0 = 12
timi_stemi_score(76, 1, 90, 110, 1, 80, 1, 0)

# Example 2: Low Risk
# 55yo (0), No Hx, SBP 130, HR 80, Killip I, 80kg, Inferior STE (0), Time <4h
# Score = 0
timi_stemi_score(55, 0, 130, 80, 0, 80, 0, 0)
}
