\name{sf_ratio}
\alias{sf_ratio}
\title{
SpO2/FiO2 Ratio (S/F Ratio)
}
\description{
Calculates the SpO2/FiO2 (S/F) ratio, a non-invasive surrogate for the PaO2/FiO2 (P/F) ratio used to assess the severity of hypoxemia and acute respiratory distress syndrome (ARDS)

[Image of oxygen gradient diagram]
. The S/F ratio correlates with the P/F ratio, with S/F values of 235 and 315 corresponding approximately to P/F values of 200 and 300, respectively.
}
\usage{
sf_ratio(spo2_percent, fio2_percent)
}
\arguments{
  \item{spo2_percent}{
Numeric. Oxygen saturation as measured by pulse oximetry (0-100\%).
}
  \item{fio2_percent}{
Numeric. Fraction of Inspired Oxygen (can be entered as a percentage e.g., 40, or decimal e.g., 0.40).
}
}
\value{
A list containing:
\item{SF_Ratio}{The calculated S/F ratio.}
\item{Interpretation}{Clinical interpretation regarding ARDS severity.}
\item{Estimated_PF_Ratio}{Approximate corresponding P/F ratio range.}
}
\references{
Rice TW, Wheeler AP, Bernard GR, et al. Comparison of the SpO2/FIO2 ratio and the PaO2/FIO2 ratio in patients with acute lung injury or ARDS. Chest. 2007;132(2):410-417. doi:10.1378/chest.07-0617
}
\examples{

# Example 1: Severe Hypoxemia (ARDS)
# SpO2 88%, FiO2 0.60
# Ratio = 88 / 0.6 = 146.7
sf_ratio(88, 60)

# Example 2: Normal/Mild
# SpO2 98%, Room Air (0.21)
# Ratio = 98 / 0.21 = 466.7
sf_ratio(98, 21)
}
