\name{score2_cvd_risk}
\alias{score2_cvd_risk}
\title{
SCORE2 Risk Prediction Algorithm
}
\description{
Calculates the 10-year risk of fatal and non-fatal cardiovascular disease (CVD) events in individuals aged 40-69 years without prior CVD or diabetes, using the SCORE2 algorithm. The model is calibrated for four European risk regions (Low, Moderate, High, Very High).
}
\usage{
score2_cvd_risk(sex, age, smoking_status, systolic_bp, total_cholesterol,
                hdl_cholesterol = NULL, region_risk_level = "low")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years (40-69).
}
  \item{smoking_status}{
Numeric (0 or 1). Current smoker status. (1 = Yes).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{total_cholesterol}{
Numeric. Total cholesterol level in mmol/L or mg/dL. (If >15, assumed mg/dL and converted).
}
  \item{hdl_cholesterol}{
Numeric (Optional). HDL cholesterol level in mmol/L or mg/dL. Used to calculate non-HDL cholesterol.
}
  \item{region_risk_level}{
String. Risk region classification. Options: "low", "moderate", "high", "very_high".
}
}
\value{
A list containing:
\item{SCORE2_Risk_10yr}{The estimated 10-year risk of fatal/non-fatal CVD.}
\item{Risk_Category}{Risk classification based on age-specific thresholds.}
}
\references{
SCORE2 working group and ESC Cardiovascular Risk Collaboration. SCORE2 risk prediction algorithms: new models to estimate 10-year risk of cardiovascular disease in Europe. Eur Heart J. 2021;42(25):2439-2454. doi:10.1093/eurheartj/ehab309
}
\examples{

# Example 1: Moderate Risk Region
# Male, 55yo, Smoker, SBP 140, Total Chol 5.5 mmol/L (Non-HDL approx 4.0)
score2_cvd_risk("male", 55, 1, 140, 5.5, 1.5, "moderate")

# Example 2: Low Risk Region
# Female, 60yo, Non-smoker, SBP 120, Non-HDL 3.0 mmol/L
score2_cvd_risk("female", 60, 0, 120, 3.0, 0, "low")
}
