\name{kt_v_dialysis}
\alias{kt_v_dialysis}
\title{
Kt/V for Dialysis Adequacy (Daugirdas Formula)
}
\description{
Calculates the single-pool Kt/V (spKt/V) for hemodialysis adequacy using the Daugirdas Second Generation formula. This metric quantifies the dose of dialysis delivered by measuring urea clearance normalized to the patient's total body water volume.
}
\usage{
kt_v_dialysis(pre_bun, post_bun, duration_hours, uf_volume_liters,
              post_weight_kg)
}
\arguments{
  \item{pre_bun}{
Numeric. Pre-dialysis Blood Urea Nitrogen (BUN) level (mg/dL or mmol/L). Units must match post_bun.
}
  \item{post_bun}{
Numeric. Post-dialysis Blood Urea Nitrogen (BUN) level (mg/dL or mmol/L). Units must match pre_bun.
}
  \item{duration_hours}{
Numeric. Duration of the dialysis session in hours.
}
  \item{uf_volume_liters}{
Numeric. Volume of ultrafiltrate removed during the session in Liters.
}
  \item{post_weight_kg}{
Numeric. Patient's post-dialysis weight in kilograms.
}
}
\details{
The formula used is the Daugirdas Second Generation Logarithmic Estimate:
\deqn{Kt/V = -ln(R - 0.008 \times t) + (4 - 3.5 \times R) \times \frac{UF}{W}}
Where:
\itemize{
  \item \eqn{R} = Post-BUN / Pre-BUN
  \item \eqn{t} = Duration in hours
  \item \eqn{UF} = Ultrafiltration volume in Liters
  \item \eqn{W} = Post-dialysis weight in kg
}
}
\value{
A list containing:
\item{Kt_V_Score}{The calculated Kt/V value.}
\item{Interpretation}{Clinical interpretation based on the standard adequacy target (>= 1.2).}
}
\references{
Daugirdas JT. Second generation logarithmic estimates of single-pool variable volume Kt/V: an analysis of error. J Am Soc Nephrol. 1993;4(5):1205-1213. doi:10.1681/ASN.V451205
}
\examples{

# Example 1: Adequate Dialysis
# Pre 80, Post 25, 4 hours, 3L UF, 70kg
kt_v_dialysis(80, 25, 4, 3, 70)

# Example 2: Inadequate Dialysis
# Pre 80, Post 40, 3 hours, 2L UF, 80kg
kt_v_dialysis(80, 40, 3, 2, 80)
}
