\name{hospital_readmission_score}
\alias{hospital_readmission_score}
\title{
HOSPITAL Score for Readmissions
}
\description{
Calculates the HOSPITAL score to predict the risk of potentially avoidable 30-day readmission in medical patients discharged from the hospital. The score uses seven readily available clinical and administrative variables.
}
\usage{
hospital_readmission_score(hemoglobin_level, oncology_service, sodium_level,
                           procedure_during_admission, admission_type_index,
                           length_of_stay, previous_admissions)
}
\arguments{
  \item{hemoglobin_level}{
Numeric. Hemoglobin level at discharge (g/dL). (< 12 g/dL adds 1 point).
}
  \item{oncology_service}{
Numeric (0 or 1). Discharged from an Oncology service. (1 = Yes, +2 points).
}
  \item{sodium_level}{
Numeric. Sodium level at discharge (mEq/L). (< 135 mEq/L adds 1 point).
}
  \item{procedure_during_admission}{
Numeric (0 or 1). Was any ICD-coded procedure performed during admission? (1 = Yes, 0 = No). Note: "No" adds 1 point.
}
  \item{admission_type_index}{
Numeric (0 or 1). Index admission type (Urgent/Emergent). (1 = Yes, +1 point).
}
  \item{length_of_stay}{
Numeric. Length of stay in days. (>= 5 days adds 2 points).
}
  \item{previous_admissions}{
Numeric. Number of hospital admissions in the previous year. (0 = 0 pts, 0-1? Actually: 0-1 admissions = 0 pts? No, variable is usually "> number of admissions". Standard: >1 admission in last year? No, count: 0-1 => 0 pts. > number => +5 pts. Let's check specific bins: 0-? Actually, score is: No prior admins=0. 0-? The variable is "Number of admissions in previous 12 months".
Standard:
0-1: 0 pts.
2-5: 2 pts.
>5: 5 pts.
Wait, MDCalc uses: "Number of admissions in previous 1 year".
The code reflects the standard interpretation: >1 implies multiple?)
}
}
\value{
A list containing:
\item{HOSPITAL_Score}{The calculated score (Range 0-13).}
\item{Risk_Level}{Classification (Low 0-4, Intermediate 5-6, High >=7).}
\item{Est_Readmission_Risk_30_Day}{Estimated probability of readmission.}
}
\references{
Donzé J, Aujesky D, Williams D, Schnipper JL. Potentially avoidable 30-day hospital readmissions in medical patients: derivation and validation of a prediction model. JAMA Intern Med. 2013;173(8):632-638. doi:10.1001/jamainternmed.2013.3023
}
\examples{

# Example 1: High Risk
# Low Hgb, Oncology, Low Na, No Proc, Urgent, Long Stay, Frequent Admit
hospital_readmission_score(11, 1, 130, 0, 1, 6, 6)

# Example 2: Low Risk
# Normal Hgb, Gen Med, Normal Na, Procedure done, Elective, Short Stay, No priors
hospital_readmission_score(14, 0, 140, 1, 0, 2, 0)
}
