\name{calculate_tpa_stroke_dosing}
\alias{calculate_tpa_stroke_dosing}
\title{
tPA (Tissue Plasminogen Activator) Dosing Calculator for Stroke
}
\description{
Calculates the recommended dosing of Alteplase (tPA) for the treatment of acute ischemic stroke. The standard dose is 0.9 mg/kg, with a maximum total dose of 90 mg. 10\% of the total dose is administered as an initial bolus over 1 minute, and the remaining 90\% is infused over 60 minutes.
}
\usage{
calculate_tpa_stroke_dosing(weight_kg)
}
\arguments{
  \item{weight_kg}{
Numeric. The patient's weight in kilograms.
}
}
\value{
A list containing:
\item{Total_Dose_mg}{The total calculated dose (Max 90 mg).}
\item{Bolus_Dose_mg}{The 10\% bolus dose to be given over 1 minute.}
\item{Infusion_Dose_mg}{The 90\% remaining dose to be infused over 60 minutes.}
\item{Discard_Amount_from_100mg_Vial}{The amount of medication to discard from a standard 100 mg vial to prevent overdose.}
}
\references{
The National Institute of Neurological Disorders and Stroke rt-PA Stroke Study Group. Tissue plasminogen activator for acute ischemic stroke. N Engl J Med. 1995;333(24):1581-1587. doi:10.1056/NEJM199512143332401
}
\examples{

# Example 1: 70 kg patient
# Total = 0.9 * 70 = 63 mg
# Bolus = 6.3 mg, Infusion = 56.7 mg
calculate_tpa_stroke_dosing(70)

# Example 2: 110 kg patient (Max dose applies)
# Total = 0.9 * 110 = 99 -> Capped at 90 mg
# Bolus = 9 mg, Infusion = 81 mg
calculate_tpa_stroke_dosing(110)
}
